/**************************************************************

	Script		: MultiBox
	Version		: 1.3.1
	Authors		: Samuel Birch (modified by Liam Smart for MooTools 1.2)
	Desc		: Supports jpg, gif, png, flash, flv, mov, wmv, mp3, html, iframe
	Licence		: Open Source MIT Licence
	Modified	: Leonardo Di Lella (leonardo@dilella.org) - MooTools 1.2 support
				: Liam Smart (liam_smart@hotmail.com)
	Usage		: window.addEvent('domready', function(){
					  if($$('.mb').length > 0)//only triggered if 'mb' class found on page
					  {
						  var initMultiBox = new multiBox('mb', {
							  descClassName: 'multiBoxDesc',//the class name of the description divs
							  path: 'Flash/',//path to mp3 and flv players
							  useOverlay: true,//use a semi-transparent background. default: false;
							  maxWidth: 600,//max width (set to false to disable)
							  maxHeight: 400,//max height (set to false to disable)
							  addDownload: false,//do you want the files to be downloadable?
							  pathToDownloadScript: './Scripts/ForceDownload.asp',//if above is true, specify download script
							  addRollover: true,//add rollover fade to each multibox link
							  addOverlayIcon: true,//adds overlay icons to images within multibox links
							  addChain: true,//cycle through all images fading them out then in
							  recalcTop: true//subtract the height of controls panel from top position
						  });
					  };
				  });

**************************************************************/

//start multibox class
var multiBox = new Class({
	
	getOptions: function(){
		return {
			initialWidth: 250,
			initialHeight: 250,
			container: $(document.body),
			useOverlay: false,
			contentColor: '#FFF',
			showNumbers: true,
			showControls: true,
			waitDuration: 2000,
			descClassName: false,
			movieWidth: 400,
			movieHeight: 300,
			offset: {x:0, y:0},
			fixedTop: false,
			path: './Files/',
			openFromLink: true,
			relativeToWindow: true,
			onOpen: new Class(),
			onClose: new Class()
		};
	},

	initialize:function(className,options)
	{
		this.setOptions(this.getOptions(),options);
		this.openClosePos = {};
		this.timer = 0;
		this.contentToLoad = {};
		this.index = 0;
		this.opened = false;
		this.contentObj = {};
		this.containerDefaults = {};
		this.content = $$('.'+className);
		
		if(this.options.useOverlay)
		{
			this.overlay = new Overlay({container:this.options.container,onClick:this.close.bind(this)});
		};
		
		//only if overlay is enabled in the top settings (liam)
		if(this.options.addOverlayIcon == true)
		{
			this.addOverlayIcon(this.content);
		};
		
		//only if addRollover is enabled in the top settings (liam)
		if(this.options.addRollover == true)
		{
			this.addRollover(this.content);
		};
		
		//only if startChain is enabled in the top settings (liam)
		if(this.options.addChain == true)
		{
			this.addChain(this.content);
		};
		
		if(this.options.descClassName)
		{
			this.descriptions = $$('.'+this.options.descClassName);
			this.descriptions.each(function(el){
				el.setStyle('display','none');
			});
		};
		
		this.container = new Element('div').addClass('MultiBoxContainer').inject(this.options.container,'inside');
		this.iframe = new Element('iframe').setProperties({
			'id': 'multiBoxIframe',
			'name': 'mulitBoxIframe',
			'src': 'javascript:void(0);',
			'frameborder': 0,
			'scrolling': 'no'
		}).setStyles({
			'position': 'absolute',
			'top': '0',
			'left': '0',
			'width': '100%',
			'height': '100%',
			'filter': 'progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)',
			'opacity': 0
		}).inject(this.container,'inside');
		this.box = new Element('div').addClass('MultiBoxContent').inject(this.container,'inside');
		
		this.closeButton = new Element('div').addClass('MultiBoxClose').inject(this.container,'inside').addEvent('click', this.close.bind(this));
		
		this.controlsContainer = new Element('div').addClass('MultiBoxControlsContainer').inject(this.container,'inside');
		this.controls = new Element('div').addClass('MultiBoxControls').inject(this.controlsContainer,'inside');
		
		this.previousButton = new Element('div').addClass('MultiBoxPrevious').inject(this.controls,'inside').addEvent('click', this.previous.bind(this));
		this.nextButton = new Element('div').addClass('MultiBoxNext').inject(this.controls,'inside').addEvent('click', this.next.bind(this));
		
		this.title = new Element('div').addClass('MultiBoxTitle').inject(this.controls,'inside');
		this.number = new Element('div').addClass('MultiBoxNumber').inject(this.controls,'inside');
		this.description = new Element('div').addClass('MultiBoxDescription').inject(this.controls,'inside');
		if(this.options.addDownload == true)//only if download is enabled in the top settings (liam)
		{
			this.download = new Element('div').addClass('MultiBoxDownload').inject(this.controls,'inside');
			this.download.setStyles({
				'margin-left': 0
			});
		};
		
		if(this.content.length == 1)
		{
			this.title.setStyles({
				'margin-left': 0
			});
			this.description.setStyles({
				'margin-left': 0
			});
			
			this.controlsContainer.setStyles('display', 'none');
			this.previousButton.setStyle('display', 'none');
			this.nextButton.setStyle('display', 'none');
			this.number.setStyle('display', 'none');
		};
		
		new Element('div').setStyle('clear', 'both').inject(this.controls,'inside');
		
		this.content.each(function(el,i){
			el.index = i;
			el.addEvent('click', function(e){
				new Event(e).stop();
				this.open(el);
			}.bind(this));
			if(el.href.indexOf('#') > -1)
			{
				el.content = $(el.href.substr(el.href.indexOf('#')+1));
				if(el.content)
				{
					el.content.setStyle('display','none');
				};
			};
		}, this);
		
		this.containerEffects = new Fx.Morph(this.container, {duration: 400});
		this.controlEffects = new Fx.Morph(this.controlsContainer, {duration: 300});
		
		this.reset();
	},
	
	setContentType: function(link)
	{
		var str = link.href.substr(link.href.lastIndexOf('.')+1).toLowerCase();
		var contentOptions = {};
		if($chk(link.rel))
		{
			var optArr = link.rel.split(',');
			optArr.each(function(el){
				var ta = el.split(':');
				contentOptions[ta[0]] = ta[1];
			});
		};
		
		if(contentOptions.type != undefined)
		{
			str = contentOptions.type;
		};
		
		this.contentObj = {};
		this.contentObj.url = link.href;
		this.contentObj.xH = 0;
		
		if(contentOptions.width)
		{
			this.contentObj.width = contentOptions.width;
		}
		else
		{
			this.contentObj.width = this.options.movieWidth;
		};
		if(contentOptions.height)
		{
			this.contentObj.height = contentOptions.height;	
		}
		else
		{
			this.contentObj.height = this.options.movieHeight;
		};
		if(contentOptions.panel)
		{
			this.panelPosition = contentOptions.panel;
		}
		else
		{
			this.panelPosition = this.options.panel;
		};
		
		switch(str){
			case 'jpg':
			case 'gif':
			case 'png':
				this.type = 'image';
				break;
			case 'swf':
				this.type = 'flash';
				break;
			case 'flv':
				this.type = 'flashVideo';
				this.contentObj.xH = 70;
				break;
			case 'mov':
				this.type = 'quicktime';
				break;
			case 'mp4'://to support mp4 format (code from phatfusion forum - liam)
			   this.type = 'quicktime';
			   break;
			case 'wmv':
				this.type = 'windowsMedia';
				break;
			case 'rv':
			case 'rm':
			case 'rmvb':
				this.type = 'real';
				break;
			case 'mp3':
				this.type = 'flashMp3';
				this.contentObj.width = 320;
				this.contentObj.height = 70;
				break;
			case 'element':
				this.type = 'htmlelement';
				this.elementContent = link.content;
				this.elementContent.setStyles({
					display: 'block',
					opacity: 0,
					width: 'auto'//added this to get htmlElement to behave (liam)
				});
	
				if(this.elementContent.getStyle('width') != 'auto')
				{
					this.contentObj.width = this.elementContent.getSize().x;
				};
				
				this.contentObj.height = this.elementContent.getSize().y;
				this.elementContent.setStyles({
					display: 'none',
					opacity: 1
				});
				break;
				
			default:
				
				this.type = 'iframe';
				if(contentOptions.req)
				{
					this.type = 'req';
				};
				break;
		}
	},
	
	reset: function()
	{
		this.container.setStyles({
			'opacity': 0,
			'display': 'none'
		});
		this.controlsContainer.setStyles({
			'height': 0,
			'display': 'none'
		});
		this.removeContent();
		this.previousButton.removeClass('MultiBoxButtonDisabled');
		this.nextButton.removeClass('MultiBoxButtonDisabled');
		this.opened = false;
	},
	
	getOpenClosePos: function(el)
	{
		if(this.options.openFromLink)
		{
			if (el.getFirst())
			{
				var w = el.getFirst().getCoordinates().width - (this.container.getStyle('border').toInt() * 2);
				if(w < 0)
				{
					w = 0;
				};
				var h = el.getFirst().getCoordinates().height - (this.container.getStyle('border').toInt() * 2);
				if(h < 0)
				{
					h = 0;
				};
				this.openClosePos = {
					width: w,
					height: h,
					top: el.getFirst().getCoordinates().top,
					left: el.getFirst().getCoordinates().left
				};
			}
			else
			{
				var w = el.getCoordinates().width - (this.container.getStyle('border').toInt() * 2);
				if(w < 0)
				{
					w = 0;
				};
				var h = el.getCoordinates().height - (this.container.getStyle('border').toInt() * 2);
				if(h < 0)
				{
					h = 0;
				};
				this.openClosePos = {
					width: w,
					height: h,
					top: el.getCoordinates().top,
					left: el.getCoordinates().left
				};
			}
		}
		else
		{
			if(this.options.fixedTop)
			{
				var top = this.options.fixedTop;
			}
			else
			{
				var top = ((window.getHeight()/2)-(this.options.initialHeight/2)-this.container.getStyle('border').toInt())+this.options.offset.y;
			};
			this.openClosePos = {
				width: this.options.initialWidth,
				height: this.options.initialHeight,
				top: top,
				left: ((window.getWidth()/2)-(this.options.initialWidth/2)-this.container.getStyle('border').toInt())+this.options.offset.x
			};
		};
		return this.openClosePos;
	},
	
	open: function(el)
	{
		this.index = this.content.indexOf(el);
		
		this.openId = el.getProperty('id');
		
		if(!this.opened)
		{
			this.opened = true;
			
			if(this.options.useOverlay)
			{
				this.overlay.show();
			};
			
			this.container.setStyles(this.getOpenClosePos(el));
			this.container.setStyles({
				opacity: 0,
				display: 'block'
			});
			
			if(this.options.fixedTop)
			{
				var top = this.options.fixedTop;
			}
			else
			{
				var top = ((window.getHeight()/2)-(this.options.initialHeight/2)-this.container.getStyle('border').toInt())+this.options.offset.y;
			};
			
			this.containerEffects.start({
				width: this.options.initialWidth,
				height: this.options.initialHeight,
				top: top,
				left: ((window.getWidth()/2)-(this.options.initialWidth/2)-this.container.getStyle('border').toInt())+this.options.offset.x,
				opacity: [0, 1]
			});
			
			this.load(this.index);
		
		}
		else
		{
			if(this.options.showControls)
			{
				this.hideControls();
			};
			this.getOpenClosePos(this.content[this.index]);
			this.timer = this.hideContent.bind(this).delay(500);
			this.timer = this.load.pass(this.index, this).delay(1100);
		};
	},
	
	getContent: function(index)
	{
		this.setContentType(this.content[index]);
		var desc = {};
		if(this.options.descClassName)
		{
			this.descriptions.each(function(el,i)
			{
				if(el.hasClass(this.openId))
				{
					desc = el.clone();
				};
			},this);
		};
		if(this.options.addDownload == true)//only if download is enabled in the top settings (liam)
		{
			var FilePath = this.content[index];//get full path to file
			var splitFileName = String(FilePath).split('/');//split it into array to get file name
			var FileName = splitFileName[splitFileName.length-1];//file name will equal the last part obviously
			FilePath = String(FilePath);//make sure its in a string format
			this.download.set('html','<a href=\"'+this.options.pathToDownloadScript+'?FilePath='+FilePath+'\" title="Download File '+FileName+'\">Download File</a>');//force download the file using ASP
		};
		//var title = this.content[index].title;
		this.contentToLoad = {
			title: this.content[index].title || '&nbsp;',
			desc: desc,
			number: index+1
		};
	},
	
	close: function()
	{
		if(this.options.useOverlay)
		{
			this.overlay.hide();
		};
		if (this.options.showControls)
		{
			this.hideControls();
		};
		this.hideContent();
		this.containerEffects.cancel();
		this.zoomOut.bind(this).delay(500);
		this.options.onClose();
	},
	
	zoomOut: function()
	{
		this.containerEffects.start({
			width: this.openClosePos.width,
			height: this.openClosePos.height,
			top: this.openClosePos.top,
			left: this.openClosePos.left,
			opacity: 0
		});
		this.reset.bind(this).delay(500);
	},
	
	load: function(index)
	{
		this.box.addClass('MultiBoxLoading');
		this.getContent(index);
		if(this.type == 'image')
		{
			var xH = this.contentObj.xH;
			this.contentObj = new Asset.image(this.content[index].href, {onload: this.resize.bind(this)});
			this.contentObj.xH = xH;
		}
		else
		{
			this.resize();
		};
	},
	
	resize: function()
	{
		//only resize if values have been set to resize to (liam)
		if(this.options.maxHeight != false || this.options.maxWidth != false)
		{
			if(this.options.maxHeight != null)//resize image added for new version(can only resize images! not video)
			{
				var maxH = this.options.maxHeight;//declare max height at top of script
			};
			if(this.options.maxWidth != null)
			{
				var maxW = this.options.maxWidth;//declare max width at top of script
			};
				
			var dW = 0;//set initial final width to 0
			var dH = 0;//set initial final height to 0
			var h = dH = this.contentObj.height;//retrieve image height
			var w = dW = this.contentObj.width;//retrieve image width
				
			if ((h >= maxH) && (w >= maxW))
			{
				if (h > w)
				{
					dH = maxH;
					dW = parseInt((w * dH) / h, 10);
				}
				else
				{
					dW = maxW;
					dH = parseInt((h * dW) / w, 10);
				};
			}
			else if((h > maxH) && (w < maxW))
			{
				dH = maxH;
				dW = parseInt((w * dH) / h, 10);
			}
			else if ((h < maxH) && (w > maxW))
			{
				dW = maxW;
				dH = parseInt((h * dW) / w, 10);
			};
				
			this.contentObj.height = dH;//resize image height
			this.contentObj.width = dW;//resize image width
		};
		
		if(this.options.fixedTop)
		{
			var top = this.options.fixedTop;
		}
		else
		{
			var top = ((window.getHeight() / 2) - ((Number(this.contentObj.height) + this.contentObj.xH) / 2) - this.container.getStyle('border').toInt() + window.getScrollTop()) + this.options.offset.y;
		};
		var left = ((window.getWidth() / 2) - (this.contentObj.width / 2) - this.container.getStyle('border').toInt()) + this.options.offset.x;
		if(top < 0)
		{
			top = 0;
		};
		if(left < 0)
		{
			left = 0;
		};
		
		this.containerEffects.cancel();
		this.containerEffects.start({
			width: this.contentObj.width,
			height: Number(this.contentObj.height) + this.contentObj.xH,
			top: top,
			left: left,
			opacity: 1
		});
		this.timer = this.showContent.bind(this).delay(500);
	},
	
	showContent: function()
	{
		this.box.removeClass('MultiBoxLoading');
		this.removeContent();

		this.contentContainer = new Element('div').setProperties({id: 'MultiBoxContentContainer'}).setStyles({opacity: 0, width: this.contentObj.width+'px', height: (Number(this.contentObj.height)+this.contentObj.xH)+'px'}).inject(this.box,'inside');
		
		if(this.type == 'image')
		{
			this.contentObj.inject(this.contentContainer,'inside');
		}
		else if(this.type == 'iframe')
		{
			new Element('iframe').setProperties({
				id: 'iFrame'+new Date().getTime(), 
				width: this.contentObj.width,
				height: this.contentObj.height,
				src: this.contentObj.url,
				frameborder: 0,
				scrolling: 'auto'
			}).inject(this.contentContainer,'inside');
		}
		else if(this.type == 'htmlelement')
		{
			this.elementContent.clone().setStyle('display','block').inject(this.contentContainer,'inside');
		}
		else if(this.type == 'req')//fixes ajax bug (mootools docs code - liam)
		{
			new Request.HTML({
				update: $('MultiBoxContentContainer'),
				autoCancel: true
			}).get(this.contentObj.url);
		}
		else
		{
			var obj = this.createEmbedObject().inject(this.contentContainer,'inside');
			if(this.str != '')
			{
				$('MultiBoxMediaObject').set('html',this.str);
			};
		};
		
		this.contentEffects = new Fx.Morph(this.contentContainer, {duration: 500});
		this.contentEffects.start({
			opacity: 1
		});
		
		this.title.set('html',this.contentToLoad.title);
		this.number.set('html',this.contentToLoad.number+' of '+this.content.length);
		if(this.options.descClassName)
		{
			if(this.description.getFirst())
			{
				this.description.getFirst().destroy();
			};
			this.contentToLoad.desc.inject(this.description,'inside').setStyles({
				display: 'block'
			});
		};

		if(this.options.showControls)
		{
			this.timer = this.showControls.bind(this).delay(800);
		};
	},
	
	hideContent: function()
	{
		this.box.addClass('MultiBoxLoading');
		this.contentEffects.start({
			opacity: 0
		});
		this.removeContent.bind(this).delay(500);
	},
	
	removeContent: function()
	{
		if($('MultiBoxMediaObject'))
		{
			$('MultiBoxMediaObject').destroy();
		};
		if($('MultiBoxContentContainer'))
		{
			$('MultiBoxContentContainer').destroy();	
		};
	},
	
	showControls: function()
	{
		this.clicked = false;
		this.controlsContainer.setStyles({
			'width': this.container.getStyle('width')
		}); 
			
		if(this.container.getStyle('height') != 'auto')
		{
			this.containerDefaults.height = this.container.getStyle('height');
			
			this.containerDefaults.backgroundColor = this.options.contentColor;
			
			//controls box isnt taken into consideration when positioning the container from the top so correct this
			if(this.options.recalcTop == true)
			{
				if(this.container.getStyle('top').toInt() > this.controls.getStyle('height').toInt()/2)
				{
					this.finalResize = new Fx.Morph(this.container,{duration:400});
					this.finalResize.start({
						top: this.container.getStyle('top').toInt()-(this.controls.getStyle('height').toInt()/2)+'px'
					});
				};
			};
		};
		
		this.container.setStyles({
			'height': 'auto'
		});
        
		if(this.contentToLoad.number == 1)
		{
			this.previousButton.addClass('MultiBoxPreviousDisabled');
		}
		else
		{
			this.previousButton.removeClass('MultiBoxPreviousDisabled');
		};
		if(this.contentToLoad.number == this.content.length)
		{
			this.nextButton.addClass('MultiBoxNextDisabled');
		}
		else
		{
			this.nextButton.removeClass('MultiBoxNextDisabled');
		};
		
		this.controlEffects.start({'height': this.controls.getStyle('height')
		                           });
		this.controlsContainer.setStyles({'height':this.controls.getStyle('height'),'display': 'block'});                           
	},
	
	hideControls: function(num)
	{   
		this.controlEffects.start({'height': 0,'display': 'none'}).chain(function(){
			this.container.setStyles(this.containerDefaults);
		}.bind(this));
		
	},
	
	showThumbnails: function()
	{
		
	},
	
	next: function()
	{
		if(this.index < this.content.length-1)
		{
			this.index++;
			this.openId = this.content[this.index].getProperty('id');
			if (this.options.showControls)
			{
				this.hideControls();
			};
			this.getOpenClosePos(this.content[this.index]);
			this.timer = this.hideContent.bind(this).delay(500);
			this.timer = this.load.pass(this.index, this).delay(1100);
		};
	},
	
	previous: function()
	{
		if(this.index > 0)
		{
			this.index--;
			this.openId = this.content[this.index].getProperty('id');
			if (this.options.showControls)
			{
				this.hideControls();
			};
			this.getOpenClosePos(this.content[this.index]);
			this.timer = this.hideContent.bind(this).delay(500);
			this.timer = this.load.pass(this.index, this).delay(1000);
		};
	},
	
	createEmbedObject: function()
	{
		if(this.type == 'flash')
		{
			var url = this.contentObj.url;
			var obj = new Element('div').setProperties({id: 'MultiBoxMediaObject'});
			this.str = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,28,0" '
			this.str += 'width="'+this.contentObj.width+'" ';
			this.str += 'height="'+this.contentObj.height+'" ';
			this.str += 'title="MultiBoxMedia">';
  			this.str += '<param name="movie" value="'+url+'" />'
  			this.str += '<param name="quality" value="high" />';
			this.str += '<param name="wmode" value="transparent" />';//better way to embed flash(liam)
  			this.str += '<embed src="'+url+'" ';
  			this.str += 'quality="high" pluginspage="http://www.adobe.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash" type="application/x-shockwave-flash" ';
  			this.str += 'width="'+this.contentObj.width+'" ';
  			this.str += 'height="'+this.contentObj.height+'"></embed>';
			this.str += '</object>';
		};
		
		if(this.type == 'flashVideo')
		{
			//var url = this.contentObj.url.substring(0, this.contentObj.url.lastIndexOf('.'));
			var url = this.contentObj.url;
			var obj = new Element('div').setProperties({id: 'MultiBoxMediaObject'});
			this.str = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,28,0" '
			this.str += 'width="'+this.contentObj.width+'" ';
			this.str += 'height="'+(Number(this.contentObj.height)+this.contentObj.xH)+'" ';
			this.str += 'title="MultiBoxMedia">';
  			this.str += '<param name="movie" value="'+this.options.path+'flvplayer.swf" />'
  			this.str += '<param name="quality" value="high" />';
  			this.str += '<param name="salign" value="TL" />';
  			this.str += '<param name="scale" value="noScale" />';
  			this.str += '<param name="FlashVars" value="path='+url+'" />';
  			this.str += '<embed src="'+this.options.path+'flvplayer.swf" ';
  			this.str += 'quality="high" pluginspage="http://www.adobe.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash" type="application/x-shockwave-flash" ';
  			this.str += 'width="'+this.contentObj.width+'" ';
  			this.str += 'height="'+(Number(this.contentObj.height)+this.contentObj.xH)+'"';
  			this.str += 'salign="TL" ';
  			this.str += 'scale="noScale" ';
  			this.str += 'FlashVars="path='+url+'"';
  			this.str += '></embed>';
			this.str += '</object>';
		};
		
		if(this.type == 'flashMp3')
		{
			var url = this.contentObj.url;
			var obj = new Element('div').setProperties({id: 'MultiBoxMediaObject'});
			this.str = '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,28,0" '
			this.str += 'width="'+this.contentObj.width+'" ';
			this.str += 'height="'+this.contentObj.height+'" ';
			this.str += 'title="MultiBoxMedia">';
  			this.str += '<param name="movie" value="'+this.options.path+'mp3player.swf" />'
  			this.str += '<param name="quality" value="high" />';
  			this.str += '<param name="salign" value="TL" />';
  			this.str += '<param name="scale" value="noScale" />';
  			this.str += '<param name="FlashVars" value="path='+url+'" />';
  			this.str += '<embed src="'+this.options.path+'mp3player.swf" ';
  			this.str += 'quality="high" pluginspage="http://www.adobe.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash" type="application/x-shockwave-flash" ';
  			this.str += 'width="'+this.contentObj.width+'" ';
  			this.str += 'height="'+this.contentObj.height+'"';
  			this.str += 'salign="TL" ';
  			this.str += 'scale="noScale" ';
  			this.str += 'FlashVars="path='+url+'"';
  			this.str += '></embed>';
			this.str += '</object>';
		};
		
		if(this.type == 'quicktime')
		{
			var obj = new Element('div').setProperties({id: 'MultiBoxMediaObject'});
			this.str = '<object  type="video/quicktime" classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" codebase="http://www.apple.com/qtactivex/qtplugin.cab"';
			this.str += ' width="'+this.contentObj.width+'" height="'+this.contentObj.height+'">';
			this.str += '<param name="src" value="'+this.contentObj.url+'" />';
			this.str += '<param name="autoplay" value="true" />';
			this.str += '<param name="controller" value="true" />';
			this.str += '<param name="enablejavascript" value="true" />';
			this.str += '<embed src="'+this.contentObj.url+'" autoplay="true" pluginspage="http://www.apple.com/quicktime/download/" width="'+this.contentObj.width+'" height="'+this.contentObj.height+'"></embed>';
			this.str += '<object/>';
		};
		
		if(this.type == 'windowsMedia')
		{
			var obj = new Element('div').setProperties({id: 'MultiBoxMediaObject'});
			this.str = '<object  type="application/x-oleobject" classid="CLSID:22D6f312-B0F6-11D0-94AB-0080C74C7E95" codebase="http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,4,7,1112"';
			this.str += ' width="'+this.contentObj.width+'" height="'+this.contentObj.height+'">';
			this.str += '<param name="filename" value="'+this.contentObj.url+'" />';
			this.str += '<param name="Showcontrols" value="true" />';
			this.str += '<param name="autoStart" value="true" />';
			this.str += '<embed type="application/x-mplayer2" src="'+this.contentObj.url+'" Showcontrols="true" autoStart="true" width="'+this.contentObj.width+'" height="'+this.contentObj.height+'"></embed>';
			this.str += '<object/>';
		};
		
		if(this.type == 'real')
		{
			var obj = new Element('div').setProperties({id: 'MultiBoxMediaObject'});
			this.str = '<object classid="clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA"';
			this.str += ' width="'+this.contentObj.width+'" height="'+this.contentObj.height+'">';
			this.str += '<param name="src" value="'+this.contentObj.url+'" />';
			this.str += '<param name="controls" value="ImageWindow" />';
			this.str += '<param name="autostart" value="true" />';
			this.str += '<embed src="'+this.contentObj.url+'" controls="ImageWindow" autostart="true" width="'+this.contentObj.width+'" height="'+this.contentObj.height+'"></embed>';
			this.str += '<object/>';
		};
		return obj;
	},
	
	addOverlayIcon:function(el)
	{
		//loop through each instance
		el.each(function(el,i)
		{
			//if link contains an image ad overlay
			if(el.getElement('img'))
			{
				//add position:relative to them so that icon is contained
				el.setStyle('position','relative');
					
				//inject a new div that is the overlay icon
				var overlayIcon = new Element('div').inject(el,'inside');
				overlayIcon.addClass('Overlay');
					
				//if not IE6 as IE6 causes too many issues due to lack of PNG support
				if(Browser.Engine.trident4 != true)
				{
					overlayIcon.setStyle('opacity',0);
					overlayIcon.set('tween',{duration:3000,transition:Fx.Transitions.Expo.easeIn}).tween('opacity',1);
				};
			};
		});
	},
	
	addRollover:function(el)
	{
		el.each(function(el,i)
		{
			//if link contains an image ad overlay
			if(el.getElement('img'))
			{
				//add event listener
				el.addEvents
				({
					'mouseenter': function()
					{	
						el.getElement('img').set('tween',{duration:200,transition:Fx.Transitions.linear}).tween('opacity',0.5);
					},
					'mouseleave': function()
					{
						el.getElement('img').set('tween',{duration:400,transition:Fx.Transitions.linear}).tween('opacity',1);
					}
				});
			};
		});
	},
	
	addChain:function(el)
	{
		//create new array to hold all links with images to chain through
		var chainArray = new Array();
		
		//push link into chainArray if it contains an image
		el.each(function(el,i)
		{
			//detect whether link contains image
			if(el.getElement('img'))
			{
				chainArray.push (el);
			};
		});
		
		//now chain through each item in the new array
		chainArray.each(function(el,i)
		{
			//detect whether link contains image
			if(el.getElement('img'))
			{
				//chain through each multibox link that contains an image
				var HoverMe = new Chain();
			 
				var hoverOn = function()
				{
					el.getElement('img').set('tween',{duration:200,transition:Fx.Transitions.linear}).tween('opacity',0.5);
				};
					
				var hoverOff = function()
				{
					el.getElement('img').set('tween',{duration:400,transition:Fx.Transitions.linear}).tween('opacity',1);
				};
					 
				HoverMe.chain(hoverOn);
				HoverMe.chain(hoverOff);

				HoverMe.callChain.delay(2000+(i+1)*1000,HoverMe);
				HoverMe.callChain.delay((i+2)*1000,HoverMe);
			};
		});
	}
});

multiBox.implement(new Options);
multiBox.implement(new Events);